<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:cfg=".">
  <!--
BOSCH Security Sytems (Grassbrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 25.2.2011

$Revision: 1.2 $ 

Last locked:   $Date: 2012/03/27 12:46:38GMT $

Last change by $Author: Michael Ziegel (zi82ot) $

History: 
$Log: extractNode.xsl  $
Revision 1.2 2012/03/27 12:46:38GMT Michael Ziegel (zi82ot) 
set mks revisions
Revision 1.1 2011/02/25 15:24:47MEZ Michael Ziegel (zi82ot) 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Testing/DownUpTest/DownUpTest.pj
-->
  <cfg:Stylesheet version="$Revision: 1.2 $"/>
  <xsl:param name="NetGroup" select="0"/>
  <xsl:param name="NetNode" select="'0'"/>
  <xsl:param name="RemoveAttributes" select="'true'"/>
  <xsl:output method="xml" indent="yes"/>
  
     <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
   <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
   <xsl:template match="*">
      <xsl:element name="{name()}">
         <!-- RPS writes newlines into empty elements sometimes -->
         <xsl:choose>
            <xsl:when test="./* = false()">
               <xsl:value-of select="normalize-space(.)"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:element>
   </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
  <xsl:if test="$RemoveAttributes = 'false'">
    <xsl:copy/>
  </xsl:if>
  </xsl:template>

  <!--****************  SELECTION of the parts which will be uploaded again  ***********************-->
  <!-- BEGIN -->
  <xsl:template match="EXPORTS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="EXPORTS">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <xsl:template match="IMPORTS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="IMPORTS">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- USED_SIS begin -->
  <xsl:template match="USED_SIS">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="USED_SI">
          <xsl:sort select="localID" data-type="text"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="CONNECTABLE">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup and count(*) != 0">
      <xsl:element name="CONNECTABLE">
        <xsl:if test="*">
          <xsl:apply-templates/>
        </xsl:if>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="ASSIGNED_OPCSVRS">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="ASSIGNED_OPCSVRS">
        <xsl:if test="*">
          <xsl:apply-templates/>
        </xsl:if>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="ASSIGNED_MTS_NODES">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:if test="*">
        <xsl:element name="ASSIGNED_MTS_NODES">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <xsl:template match="CONFIG_DATA">
    <xsl:if test="../netNode = $NetNode and ../netGroup = $NetGroup">
      <xsl:element name="CONFIG_DATA">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- RPS adds empty element NET_INTERFACES to NODE of type OPC_SERVER -->
  <xsl:template match="NET_INTERFACES">
    <xsl:choose>
      <xsl:when test="../nodeType != 'OPC_SERVER'">
        <xsl:element name="NET_INTERFACES">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <!-- END -->
</xsl:stylesheet>
